(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     31757,        757]
NotebookOptionsPosition[     31403,        743]
NotebookOutlinePosition[     31797,        759]
CellTagsIndexPosition[     31754,        756]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"-", "Storage"}]}], " ", 
     RowBox[{"initialization", "--"}]}], "-"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"reactionData", "=", 
     RowBox[{"<|", "|>"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"reactionPlots", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"cornerReactions", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"-", "Symbolic"}]}], " ", "and", " ", "parameter", " ", 
      RowBox[{"assumptions", "--"}]}], "-"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Assumes", ":", "xmin"}], ",", "xmax", ",", "ymin", ",", "ymax", 
     ",", "DmembraneNum", ",", 
     RowBox[{"wMemSol", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ",", 
     RowBox[{"wBendSol", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ",", "Dbending", ",", "\[Nu]", ",", 
     "q", ",", 
     RowBox[{"boundaryType", " ", "are", " ", 
      RowBox[{"defined", "."}]}]}], "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"--", 
     RowBox[{"-", 
      RowBox[{"Helper", ":", 
       RowBox[{
        RowBox[{"Generate", " ", "edge", " ", "and", " ", "corner", " ", 
         RowBox[{"definitions", "--"}]}], "-"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"edges", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<x = xmin\>\""}], ",", 
         RowBox[{"\"\<coord\>\"", "->", "xmin"}], ",", 
         RowBox[{"\"\<start\>\"", "->", "ymin"}], ",", 
         RowBox[{"\"\<end\>\"", "->", "ymax"}], ",", 
         RowBox[{"\"\<normal\>\"", "->", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}]}], "|>"}], ",", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<x = xmax\>\""}], ",", 
         RowBox[{"\"\<coord\>\"", "->", "xmax"}], ",", 
         RowBox[{"\"\<start\>\"", "->", "ymin"}], ",", 
         RowBox[{"\"\<end\>\"", "->", "ymax"}], ",", 
         RowBox[{"\"\<normal\>\"", "->", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}]}], "|>"}], ",", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<y = ymin\>\""}], ",", 
         RowBox[{"\"\<coord\>\"", "->", "ymin"}], ",", 
         RowBox[{"\"\<start\>\"", "->", "xmin"}], ",", 
         RowBox[{"\"\<end\>\"", "->", "xmax"}], ",", 
         RowBox[{"\"\<normal\>\"", "->", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}]}], "|>"}], ",", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<y = ymax\>\""}], ",", 
         RowBox[{"\"\<coord\>\"", "->", "ymax"}], ",", 
         RowBox[{"\"\<start\>\"", "->", "xmin"}], ",", 
         RowBox[{"\"\<end\>\"", "->", "xmax"}], ",", 
         RowBox[{"\"\<normal\>\"", "->", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}]}], "|>"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"corners", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<Corner (-25, -25)\>\""}], ",", 
         RowBox[{"\"\<x\>\"", "->", 
          RowBox[{"-", "25"}]}], ",", 
         RowBox[{"\"\<y\>\"", "->", 
          RowBox[{"-", "25"}]}]}], "|>"}], ",", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<Corner (+25, -25)\>\""}], ",", 
         RowBox[{"\"\<x\>\"", "->", "25"}], ",", 
         RowBox[{"\"\<y\>\"", "->", 
          RowBox[{"-", "25"}]}]}], "|>"}], ",", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<Corner (-25, +25)\>\""}], ",", 
         RowBox[{"\"\<x\>\"", "->", 
          RowBox[{"-", "25"}]}], ",", 
         RowBox[{"\"\<y\>\"", "->", "25"}]}], "|>"}], ",", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<name\>\"", "->", "\"\<Corner (+25, +25)\>\""}], ",", 
         RowBox[{"\"\<x\>\"", "->", "25"}], ",", 
         RowBox[{"\"\<y\>\"", "->", "25"}]}], "|>"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"-", "CORNERS"}]}], " ", 
     RowBox[{"SUPPORTED", ":", 
      RowBox[{
       RowBox[{"Compute", " ", "corner", " ", 
        RowBox[{"reactions", "--"}]}], "-"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"boundaryType", "===", "\"\<CornersSupported\>\""}], ",", 
      RowBox[{
       RowBox[{"cornerReactions", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"cornerName", ",", "xc", ",", "yc", ",", 
              RowBox[{"radius", "=", "2.0"}], ",", 
              RowBox[{"nSamples", "=", "12"}], ",", "forces", ",", 
              "reactionForce"}], "}"}], ",", 
            RowBox[{
             RowBox[{"cornerName", "=", 
              RowBox[{"corner", "[", "\"\<name\>\"", "]"}]}], ";", 
             RowBox[{"xc", "=", 
              RowBox[{"corner", "[", "\"\<x\>\"", "]"}]}], ";", 
             RowBox[{"yc", "=", 
              RowBox[{"corner", "[", "\"\<y\>\"", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"forces", "=", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Module", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                   "angle", ",", "xs", ",", "ys", ",", "Qx", ",", "Qy"}], 
                   "}"}], ",", 
                  RowBox[{
                   RowBox[{"angle", "=", 
                    RowBox[{"2", " ", "Pi", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"j", "-", "1"}], ")"}], "/", "nSamples"}]}]}], ";",
                    "\[IndentingNewLine]", 
                   RowBox[{"xs", "=", 
                    RowBox[{"xc", "+", 
                    RowBox[{"radius", " ", 
                    RowBox[{"Cos", "[", "angle", "]"}]}]}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ys", "=", 
                    RowBox[{"yc", "+", 
                    RowBox[{"radius", " ", 
                    RowBox[{"Sin", "[", "angle", "]"}]}]}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"Qx", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "DmembraneNum"}], " ", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wMemSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "/.",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "xs"}], ",", 
                    RowBox[{"y", "->", "ys"}]}], "}"}]}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"Qy", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "DmembraneNum"}], " ", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wMemSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "/.",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "xs"}], ",", 
                    RowBox[{"y", "->", "ys"}]}], "}"}]}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "Qx", "]"}], "&&", 
                    RowBox[{"NumericQ", "[", "Qy", "]"}]}], ",", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"Qx", "^", "2"}], "+", 
                    RowBox[{"Qy", "^", "2"}]}], "]"}], ",", "0"}], "]"}]}]}], 
                 "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "nSamples"}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"reactionForce", "=", 
              RowBox[{
               RowBox[{"Mean", "[", "forces", "]"}], "*", "2", " ", "Pi", " ",
                "radius"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"<|", 
              RowBox[{
               RowBox[{"\"\<corner\>\"", "->", "cornerName"}], ",", 
               RowBox[{"\"\<x\>\"", "->", "xc"}], ",", 
               RowBox[{"\"\<y\>\"", "->", "yc"}], ",", 
               RowBox[{"\"\<force\>\"", "->", "reactionForce"}]}], "|>"}]}]}],
            "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"corner", ",", "corners"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"totalCornerReaction", "=", 
        RowBox[{"Total", "[", 
         RowBox[{"cornerReactions", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "\"\<force\>\""}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Corner", " ", "reactions", " ", "plot"}], "*)"}], 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"maxForce", "=", 
           RowBox[{"Max", "[", 
            RowBox[{"Abs", "[", 
             RowBox[{"cornerReactions", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "\"\<force\>\""}], "]"}], "]"}], "]"}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"reactionPlots", "=", 
          RowBox[{"{", 
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"With", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xc", "=", 
                    RowBox[{"reaction", "[", "\"\<x\>\"", "]"}]}], ",", 
                    RowBox[{"yc", "=", 
                    RowBox[{"reaction", "[", "\"\<y\>\"", "]"}]}], ",", 
                    RowBox[{"f", "=", 
                    RowBox[{"reaction", "[", "\"\<force\>\"", "]"}]}], ",", 
                    RowBox[{"name", "=", 
                    RowBox[{"reaction", "[", "\"\<corner\>\"", "]"}]}], ",", 
                    RowBox[{"arrowLen", "=", 
                    RowBox[{"5", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"reaction", "[", "\"\<force\>\"", "]"}], "]"}], "/",
                     "maxForce"}]}]}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
                    RowBox[{"Point", "[", 
                    RowBox[{"{", 
                    RowBox[{"xc", ",", "yc"}], "}"}], "]"}], ",", "Red", ",", 
                    "Thick", ",", 
                    RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xc", ",", "yc"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"xc", ",", 
                    RowBox[{"yc", "-", "arrowLen"}]}], "}"}]}], "}"}], "]"}], 
                    ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"name", "<>", "\"\<\\n\>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Round", "[", "f", "]"}], "]"}], 
                    "<>", "\"\< N\>\""}], ",", "10", ",", "Bold"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"xc", ",", 
                    RowBox[{"yc", "+", "2"}]}], "}"}]}], "]"}]}], "}"}]}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"reaction", ",", "cornerReactions"}], "}"}]}], 
                "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"Black", ",", "Thick", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "25"}], ",", 
                    RowBox[{"-", "25"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"25", ",", 
                    RowBox[{"-", "25"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"25", ",", "25"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "25"}], ",", 
                    RowBox[{"-", "25"}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
              "}"}], ",", 
             RowBox[{"PlotLabel", "->", 
              RowBox[{"Style", "[", 
               
               RowBox[{"\"\<Corner Reactions (4-Point Support)\>\"", ",", 
                "Bold", ",", "16"}], "]"}]}], ",", 
             RowBox[{"PlotRange", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "30"}], ",", "30"}], "}"}]}], "}"}]}], ",", 
             RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
             RowBox[{"ImageSize", "->", "500"}], ",", 
             RowBox[{"Frame", "->", "True"}], ",", 
             RowBox[{"GridLines", "->", "Automatic"}], ",", 
             RowBox[{"FrameLabel", "->", 
              RowBox[{"{", 
               RowBox[{"\"\<x (m)\>\"", ",", "\"\<y (m)\>\""}], "}"}]}]}], 
            "]"}], "}"}]}]}], "]"}], ";"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"-", "EDGE"}]}], " ", "REACTIONS", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
        "all", " ", "boundary", " ", "types", " ", "except", 
         " ", "\"\<CornersSupported\>\""}], ")"}], "--"}]}], "-"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"boundaryType", "=!=", "\"\<CornersSupported\>\""}], ",", 
      RowBox[{
       RowBox[{"reactionData", "=", 
        RowBox[{"Association", "@", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "edgeName", ",", "edgeCoord", ",", "start", ",", "end", ",", 
               "normal", ",", 
               RowBox[{"nSamples", "=", "50"}], ",", "coords", ",", 
               "reactions", ",", "edgeLength", ",", "avgReaction", ",", 
               "maxReaction", ",", "totalReaction", ",", "hasBC"}], "}"}], ",", 
             RowBox[{
              RowBox[{"edgeName", "=", 
               RowBox[{"edge", "[", "\"\<name\>\"", "]"}]}], ";", 
              RowBox[{"edgeCoord", "=", 
               RowBox[{"edge", "[", "\"\<coord\>\"", "]"}]}], ";", 
              RowBox[{"start", "=", 
               RowBox[{"edge", "[", "\"\<start\>\"", "]"}]}], ";", 
              RowBox[{"end", "=", 
               RowBox[{"edge", "[", "\"\<end\>\"", "]"}]}], ";", 
              RowBox[{"normal", "=", 
               RowBox[{"edge", "[", "\"\<normal\>\"", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"hasBC", "=", 
               RowBox[{"Switch", "[", 
                RowBox[{"boundaryType", ",", 
                 RowBox[{"\"\<SimplySupported\>\"", "|", "\"\<Clamped\>\""}], 
                 ",", "True", ",", "\"\<TwoEdgeSupported\>\"", ",", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"edgeName", "==", "\"\<x = xmin\>\""}], "||", 
                   RowBox[{"edgeName", "==", "\"\<x = xmax\>\""}]}], ")"}], 
                 ",", "\"\<ThreeEdgeSupported\>\"", ",", 
                 RowBox[{"edgeName", "=!=", "\"\<y = ymax\>\""}], ",", "_", ",",
                  "False"}], "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{"hasBC", ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"normal", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "=!=", "0"}], ",", 
                   RowBox[{"(*", 
                    RowBox[{
                    RowBox[{
                    "Edge", " ", "perpendicular", " ", "to", " ", "x"}], "-", 
                    
                    RowBox[{"axis", ":", 
                    RowBox[{"sample", " ", "along", " ", "y"}]}]}], "*)"}], 
                   RowBox[{
                    RowBox[{"coords", "=", 
                    RowBox[{"Subdivide", "[", 
                    RowBox[{"start", ",", "end", ",", 
                    RowBox[{"nSamples", "-", "1"}]}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"reactions", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "DmembraneNum"}], " ", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wMemSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "/.",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "edgeCoord"}], ",", 
                    RowBox[{"y", "->", "yi"}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"yi", ",", "coords"}], "}"}]}], "]"}]}], ";"}], ",", 
                   RowBox[{"(*", 
                    RowBox[{
                    RowBox[{
                    "Edge", " ", "perpendicular", " ", "to", " ", "y"}], "-", 
                    
                    RowBox[{"axis", ":", 
                    RowBox[{"sample", " ", "along", " ", "x"}]}]}], "*)"}], 
                   RowBox[{
                    RowBox[{"coords", "=", 
                    RowBox[{"Subdivide", "[", 
                    RowBox[{"start", ",", "end", ",", 
                    RowBox[{"nSamples", "-", "1"}]}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"reactions", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "DmembraneNum"}], " ", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wMemSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "/.",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "xi"}], ",", 
                    RowBox[{"y", "->", "edgeCoord"}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"xi", ",", "coords"}], "}"}]}], "]"}]}], ";"}]}], 
                  "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"edgeLength", "=", 
                  RowBox[{"Abs", "[", 
                   RowBox[{"end", "-", "start"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"avgReaction", "=", 
                  RowBox[{"Mean", "[", "reactions", "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"maxReaction", "=", 
                  RowBox[{"Max", "[", 
                   RowBox[{"Abs", "[", "reactions", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"totalReaction", "=", 
                  RowBox[{"avgReaction", "*", "edgeLength"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"<|", 
                  RowBox[{
                   RowBox[{"\"\<edge\>\"", "->", "edgeName"}], ",", 
                   RowBox[{"\"\<coords\>\"", "->", "coords"}], ",", 
                   RowBox[{"\"\<reactions\>\"", "->", "reactions"}], ",", 
                   RowBox[{"\"\<average\>\"", "->", "avgReaction"}], ",", 
                   RowBox[{"\"\<maximum\>\"", "->", "maxReaction"}], ",", 
                   RowBox[{"\"\<total\>\"", "->", "totalReaction"}], ",", 
                   RowBox[{"\"\<edgeLength\>\"", "->", "edgeLength"}]}], 
                  "|>"}]}], ",", "Nothing"}], "]"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"edge", ",", "edges"}], "}"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Reaction", " ", "edge", " ", "plots"}], "*)"}], 
       RowBox[{"reactionPlots", "=", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"edgeName", "=", 
                RowBox[{"#", "[", "\"\<edge\>\"", "]"}]}], ",", 
               RowBox[{"coords", "=", 
                RowBox[{"#", "[", "\"\<coords\>\"", "]"}]}], ",", 
               RowBox[{"reactions", "=", 
                RowBox[{"#", "[", "\"\<reactions\>\"", "]"}]}], ",", 
               RowBox[{"normal", "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"SelectFirst", "[", 
                   RowBox[{"edges", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", "\"\<edge\>\"", "]"}], "==", 
                    RowBox[{"#2", "[", "\"\<name\>\"", "]"}]}], "&"}]}], 
                   "]"}], ")"}], "[", "\"\<normal\>\"", "]"}]}]}], "}"}], ",", 
             RowBox[{"ListLinePlot", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", 
                RowBox[{"{", 
                 RowBox[{"coords", ",", "reactions"}], "}"}], "]"}], ",", 
               RowBox[{"PlotLabel", "->", 
                RowBox[{"\"\<Reaction: \>\"", "<>", "edgeName"}]}], ",", 
               RowBox[{"AxesLabel", "->", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"normal", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "!=", "0"}], 
                    ",", "\"\<y (m)\>\"", ",", "\"\<x (m)\>\""}], "]"}], 
                  ",", "\"\<Reaction (N/m)\>\""}], "}"}]}], ",", 
               RowBox[{"PlotStyle", "->", 
                RowBox[{"Directive", "[", 
                 RowBox[{"Thick", ",", "Blue"}], "]"}]}], ",", 
               RowBox[{"GridLines", "->", "Automatic"}], ",", 
               RowBox[{"ImageSize", "->", "Medium"}], ",", 
               RowBox[{"Frame", "->", "True"}], ",", 
               RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], "]"}], "&"}], ",", 
          RowBox[{"Values", "[", "reactionData", "]"}]}], "]"}]}], ";"}]}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"-", "Load"}]}], " ", 
      RowBox[{"summary", "--"}]}], "-"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"shellArea", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"xmax", "-", "xmin"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"ymax", "-", "ymin"}], ")"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"totalLoad", "=", 
     RowBox[{"q", "*", "shellArea"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"-", "CLAMPED"}]}], " ", "EDGE", " ", "MOMENT", " ", 
      "REACTIONS"}], ",", 
     RowBox[{
      RowBox[{"per", " ", "unit", " ", 
       RowBox[{"length", "--"}]}], "-"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"momentPlots", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"boundaryType", "===", "\"\<Clamped\>\""}], ",", 
      RowBox[{
       RowBox[{"momentPlots", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "edgeName", ",", "edgeCoord", ",", "start", ",", "end", ",", 
              "normal", ",", 
              RowBox[{"nSamples", "=", "10"}], ",", "coords", ",", 
              "moments"}], "}"}], ",", 
            RowBox[{
             RowBox[{"edgeName", "=", 
              RowBox[{"edge", "[", "\"\<name\>\"", "]"}]}], ";", 
             RowBox[{"edgeCoord", "=", 
              RowBox[{"edge", "[", "\"\<coord\>\"", "]"}]}], ";", 
             RowBox[{"start", "=", 
              RowBox[{"edge", "[", "\"\<start\>\"", "]"}]}], ";", 
             RowBox[{"end", "=", 
              RowBox[{"edge", "[", "\"\<end\>\"", "]"}]}], ";", 
             RowBox[{"normal", "=", 
              RowBox[{"edge", "[", "\"\<normal\>\"", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"coords", "=", 
              RowBox[{"Subdivide", "[", 
               RowBox[{"start", ",", "end", ",", 
                RowBox[{"nSamples", "-", "1"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"moments", "=", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"normal", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "!=", "0"}], ",", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"yi", "=", "yi"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"wxx", "=", 
                    RowBox[{
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wBendSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "/.", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "edgeCoord"}], ",", 
                    RowBox[{"y", "->", "yi"}]}], "}"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"wyy", "=", 
                    RowBox[{
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wBendSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "2"}], "}"}]}], "]"}], "/.", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "edgeCoord"}], ",", 
                    RowBox[{"y", "->", "yi"}]}], "}"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"-", "Dbending"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"wxx", "+", 
                    RowBox[{"\[Nu]", "*", "wyy"}]}], ")"}]}]}]}], "]"}], ",", 
                  
                  RowBox[{"{", 
                   RowBox[{"yi", ",", "coords"}], "}"}]}], "]"}], ",", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xi", "=", "xi"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"wxx", "=", 
                    RowBox[{
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wBendSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "/.", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "xi"}], ",", 
                    RowBox[{"y", "->", "edgeCoord"}]}], "}"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"wyy", "=", 
                    RowBox[{
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"wBendSol", "[", 
                    RowBox[{"x", ",", "y"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "2"}], "}"}]}], "]"}], "/.", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "->", "xi"}], ",", 
                    RowBox[{"y", "->", "edgeCoord"}]}], "}"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"-", "Dbending"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"wyy", "+", 
                    RowBox[{"\[Nu]", "*", "wxx"}]}], ")"}]}]}]}], "]"}], ",", 
                  
                  RowBox[{"{", 
                   RowBox[{"xi", ",", "coords"}], "}"}]}], "]"}]}], "]"}]}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"<|", 
              RowBox[{
               RowBox[{"\"\<edge\>\"", "->", "edgeName"}], ",", 
               RowBox[{"\"\<coords\>\"", "->", "coords"}], ",", 
               RowBox[{"\"\<moments\>\"", "->", "moments"}], ",", 
               RowBox[{"\"\<max\>\"", "->", 
                RowBox[{"Max", "[", 
                 RowBox[{"Abs", "[", "moments", "]"}], "]"}]}], ",", 
               RowBox[{"\"\<avg\>\"", "->", 
                RowBox[{"Mean", "[", 
                 RowBox[{"Abs", "[", "moments", "]"}], "]"}]}]}], "|>"}]}]}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"edge", ",", "edges"}], "}"}]}], "]"}]}], ";"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Export", " ", "all", " ", "reaction", " ", "and", " ", "plot", " ", 
      "data", " ", "as", " ", "needed"}], ";", 
     RowBox[{"postprocess", " ", "using", " ", 
      RowBox[{"Dataset", "[", 
       RowBox[{"Values", "[", "reactionData", "]"}], "]"}], " ", "for", " ", 
      "tabular", " ", 
      RowBox[{"view", "."}]}]}], "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.970799985045034*^9, 3.9707999850472317`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ac114c10-3c6e-4611-a0fe-d2dd10194266"]
},
WindowSize->{808, 911},
WindowMargins->{{876, Automatic}, {203, Automatic}},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"77fe0332-8733-4e9a-a9cf-d48df1791358"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[554, 20, 30845, 721, 2408, "Input",ExpressionUUID->"ac114c10-3c6e-4611-a0fe-d2dd10194266"]
}
]
*)

(* End of internal cache information *)

